/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_156;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7403;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GenericDataProvider
implements class_2405 {
    private static final Logger log = LogManager.getLogger(GenericDataProvider.class);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).setPrettyPrinting().disableHtmlEscaping().create();
    protected final FabricDataOutput generator;
    private final class_3264 type;
    private final String folder;
    private final Gson gson;

    public GenericDataProvider(FabricDataOutput generator, class_3264 type, String folder) {
        this(generator, type, folder, GSON);
    }

    public GenericDataProvider(FabricDataOutput generator, String folder, Gson gson) {
        this(generator, class_3264.field_14190, folder, gson);
    }

    public GenericDataProvider(FabricDataOutput generator, String folder) {
        this(generator, folder, GSON);
    }

    protected CompletableFuture<?> saveThing(class_7403 cache, class_2960 location, Object materialJson) {
        return CompletableFuture.runAsync(() -> {
            try {
                String json = this.gson.toJson(materialJson);
                Path path = this.generator.method_45971().resolve(Paths.get(this.type.method_14413(), location.method_12836(), this.folder, location.method_12832() + ".json"));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)hashingOutputStream, StandardCharsets.UTF_8);
                writer.write(json);
                ((Writer)writer).close();
                cache.method_43346(path, byteArrayOutputStream.toByteArray(), hashingOutputStream.hash());
            }
            catch (IOException e) {
                log.error("Couldn't create data for {}", (Object)location, (Object)e);
            }
        }, class_156.method_18349());
    }

    public GenericDataProvider(FabricDataOutput generator, class_3264 type, String folder, Gson gson) {
        this.generator = generator;
        this.type = type;
        this.folder = folder;
        this.gson = gson;
    }
}

